(defmeth scatterplot-proto :add-quantours 
  (&key (contour-values (list .75 .90 .95 .975 1.00))
        (num-interp 16) (spokes nil) (axes t)
        (draw t) (color 'red) (width 1))
"Keyword Args:  (contour-values (list .75 .90 .95 .975 1.00)) (num-interp 16) (spokes nil) (axes t) (draw t) (color 'red) (width 1))
Adds quantours (quantile-based contours) to scatterplots. Quantours are located at quantile-levels specified by CONTOUR-VALUES, and are interpolated NUM-INTERP times for each quandrant. When SPOKES is T, lines are drawn, for each interpolant, from the center to the contour. When AXES is T, the horizontal and vertical interpolant lines are drawn. All lines have color COLOR and width WIDTH."
  (send self :norm-args `(:color ,color :width ,width :contour-values ,contour-values
                          :num-interp ,num-interp :spokes ,spokes :axes ,axes :draw ,draw))
  (let ((contours (if (> (send self :quantour-value) 1)
                          contour-values
                          (list (send self :quantour-value)))))
    (cond
      (
       (send self :quantour-xy)
       (send self :draw-contours (send self :quantour-xy)
             :contours contours :num-interp num-interp :spokes spokes :axes axes
             :draw draw :color color :width width))
      (t
       (let* ((nspokes (1+ (* 4 num-interp)))
              (ncontours (length contours))
              (overlay (first (send self :slot-value 'overlays)))
              (npts (send self :num-points))
              (x (send self :point-coordinate 
                       (select (send self :current-variables) 0) (iseq npts)))
              (y (send self :point-coordinate 
                       (select (send self :current-variables) 1) (iseq npts)))
              (xmean (mean x))
              (ymean (mean y))
              (xstdv (standard-deviation x))
              (ystdv (standard-deviation y))
              (xn (/ (- x xmean) xstdv))
              (yn (/ (- y ymean) ystdv))
              (xymat (bind-columns xn yn))
              (sin (sin (rseq pi (- pi) nspokes)))
              (cos (cos (rseq pi (- pi) nspokes)))
              (coef-mat (bind-columns sin cos))
              (L-list) (coefx) (coefy)
              (project) (xscale) (yscale)
              (L 0) (quantiles nil) (b)
              (xy) (2dxy) (xy-list)
              (x-list) (y-list) 
              (k 0) (color-on?) (draw-axes) (draw-spokes)
              )
         (send self :quantour-xy
               (send self :calculate-contours xymat num-interp contours 
                     xmean ymean xstdv ystdv axes spokes
                     color width draw :stat-type "quantiles"))
         (send self :draw-contours (send self :quantour-xy)
               :contours contours :num-interp num-interp :spokes spokes :axes axes
               :draw draw :color color :width width))
       ))))